 ; Ŀ
 ;   Tater - text/dimension text/attribute editor.                         
 ;   Modified: also Squabs the attribute in question if possible.          
 ;   Copyright 1994, 1999, 2007 by Rocket Software Ltd.                    
 ;   Software that works, for people who'd rather not...                   
 ; 

 ; Ŀ
 ;   Peel - error handler.                                                 
 ; 
 (DEFUN PEEL (shk /)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
  (setvar "snapmode" snapp)
  (if renam (redraw renam 4))
 (princ))
 ; Ŀ
 ;   Peel end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Squab - Adjust attribute widths.                           
 ; 
 (DEFUN SQUAB (parent enam / atnam blnam blscal widlst)
  (setq atnam (cdr (assoc 2 (entget enam))))
  (setq blnam (cdr (assoc 2 (setq entt (entget parent)))))
  (setq blscal (abs (cdr (assoc 41 entt))))
  (if (setq widlst (cdr (assoc (strcase blnam) (blister))))
      (vixe enam widlst blscal))
 (princ))
 ; Ŀ
 ;   Squab end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Squab - Adjust attribute widths.                           
 ;   This is the original version to be used if you want to adust every    
 ;   attribute width in the block containing the selected attribute.       
 ; 
; (DEFUN SQUAB (enam / blscal blist num sub ss ssnum enam entt)
;  (setq entt (entget enam))
;  (setq blnam (cdr (assoc 2 entt)))
;  (setq blscal (abs (cdr (assoc 41 entt))))
;  (if (setq widlst (cdr (assoc (strcase blnam) (blister))))
;      (vise enam widlst blscal))
; (princ))
 ; Ŀ
 ;   Squab end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Vixe - squeeze or stretch an attribute as required.        
 ;   Arguments: Enam, an attribute ename.                                  
 ;              Widlst, the corresponding list of attrib. and width lists. 
 ;              Blscal, the block scale.                                   
 ; 
 (DEFUN VIXE (enam widlst blscal / esav entt enam num sublst namp width realwd
                                                          scalfc widscl prev41)
  (setq esav enam)
  (setq entt (entget enam))
 ; Ŀ
 ;   Get the attribute name.                                               
 ; 
  (setq namm (cdr (assoc 2 entt)))
 ; Ŀ
 ;   Call Wcasoc to see if there is a matching sublist.                    
 ; 
  (if (setq sublst (wcasoc namm widlst ()))
      (progn
 ; Ŀ
 ;   Find the correct width from the sublist, allow for the block scale.   
 ; 
           (setq width (* (cadr sublst) blscal))
 ; Ŀ
 ;   Find the desired width scale factor from the sublist.                 
 ; 
           (setq txtscl (caddr sublst))
 ; Ŀ
 ;   Call Wits to find the actual string width.                            
 ; 
           (setq realwd (wits entt))
 ; Ŀ
 ;   Find the attribute width scale factor.                                
 ; 
           (setq widscl (cdr (setq prev41 (assoc 41 entt))))
 ; Ŀ
 ;   Compare the actual and desired widths.                                
 ; 
           (if (and (> realwd width)
                    (not (equal realwd width 0.1)))
 ; Ŀ
 ;   If the actual width is greater than the allowed width in the          
 ;   sublist, then adjust the width scale factor to make it fit.           
 ;   Wait: must also check to see if the width scale is greater than the   
 ;   ideal - if the attribute is too wide and the width scale is too       
 ;   large, then shrinking the attribute to fit may result in it just      
 ;   filling the space but still being too wide.                           
 ; 
               (progn
 ; Ŀ
 ;   Compare the actual width scale to the ideal width scale.              
 ; 
                    (if (<= widscl txtscl)
 ; Ŀ
 ;   If the actual is less than or equal to the ideal, then make it fit.   
 ; 
                        (progn
                             (setq scalfc (/ width realwd))
                             (setq widscl (* widscl scalfc))
                             (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   If the actual width scale is greater than the ideal, see if the       
 ;   attribute will be too wide if if set to the ideal.                    
 ;   If so then squash to fit, if not then set to the ideal.               
 ; 
                        (progn
                             (if (> (* realwd (/ txtscl widscl)) width)
 ; Ŀ
 ;   Squash to fit.                                                        
 ; 
                                 (progn
                                      (setq scalfc (/ width realwd))
                                      (setq widscl (* widscl scalfc))
                                      (entmod (subst (cons 41 widscl)
                                                      prev41 entt)))
 ; Ŀ
 ;   Set to the ideal width scale factor.                                  
 ; 
                                 (entmod (subst (cons 41 txtscl)
                                                 prev41 entt))))))
 ; Ŀ
 ;   Else the actual width is narrower than or equal to the available      
 ;   space.                                                                
 ; 
               (progn
 ; Ŀ
 ;   See if the attribute is narrower than it should be - if setting the   
 ;   width scale factor to the desired value would leave the attribute     
 ;   wider than the allowable space, then increase it to fill the space.   
 ; 
                    (if (> (* realwd (/ txtscl widscl)) width)
                        (progn
                             (setq scalfc (/ width realwd))
                             (setq widscl (* widscl scalfc))
                             (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Otherwise set it to the ideal width scale value.                      
 ; 
                        (progn
                             (entmod (subst (cons 41 txtscl)
                                                prev41 entt))))))))
  (entupd esav)
 (princ))
 ; Ŀ
 ;   Vixe end.                                                             
 ; 

 ; Ŀ
 ;   Tater.                                                                
 ; 
 (DEFUN C:TATER (/ nent enam renam entt typ outer cc nn)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq esav *error*)
  (setq *error* peel)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq enam (car (setq nent (nentsel "Select something textlike: "))))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" typ) (= "MTEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (princ (cdr (assoc 1 entt)))
           (redraw (setq renam (cdr (assoc -1 entt))) 3)
           (setq outer (car (reverse (car (reverse nent)))))
           (setq cc (getstring t "\nNew text or <Return> to select: "))
           (if (= cc "")
               (progn
                    (setq nn (nentsel "\nSelect source text:\n"))
                    (if nn (setq cc (assoc 1 (entget (car nn)))))
                    (if cc (setq cc (cdr cc)))))
           (if (and cc (/= cc ""))
               (progn
                    (redraw renam 4)
                    (entmod (subst (cons 1 cc) (assoc 1 entt) entt))
                    (entupd enam)
                    (if (= (type outer) 'ENAME)
                        (entupd outer)))
               (redraw renam 4))
 ; Ŀ
 ;   The next section squashes the attribute.                              
 ;   It is only called if squab is available (the subroutine wcasoc is     
 ;   defined) or the file Squab.lsp can be loaded.                         
 ; 
           (if (and (= typ "ATTRIB")
                    (or wcasoc (load "squab" nil)))
               (progn
                    (setq parent (cdr (assoc -1 (entget
                                                    (cdr (assoc 330 entt))))))
                    (squab parent enam)))))
 ; Ŀ
 ;   If you would like to adjust the width of every attribute in the       
 ;   block containing the selected attribute then you need to remove the   
 ;   word parent from the line above, leaving: (squab enam)                
 ; 
  (setvar "snapmode" snapp)
  (setq *error* esav)
 (princ))